


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
Texture2D overlay0;            // Y
Texture2D overlay1;            // UV
int mode;
float    g_fTime;                   // App's time in seconds
int overlay_Width;
int overlay_Height;
int dst_Width;
int dst_Height;


//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
//BT. 709, color Range:Limited.   (CSC) , default mode 

float4 funcNv12ToRGBABT709CSC(float3 yuv)
{
	float3 rgb;
	rgb.x = 1.1644 * (yuv.x - 16.0) + 1.7927 * (yuv.z - 128.0);
	rgb.y = 1.1644 * (yuv.x - 16.0) - 0.5329 * (yuv.z - 128.0) - 0.2132 * (yuv.y - 128.0);
	rgb.z = 1.1644 * (yuv.x - 16.0) + 2.1123 * (yuv.y - 128.0);
	return float4(rgb /255.0, 1.0);
}

//BT. 709, color Range: Full.  (HDTV)
float4 funcNv12ToRGBABT709HDTV(float3 yuv)
{
	float3 rgb;
	rgb.x = yuv.x + 1.5748 * (yuv.z - 128.0);
	rgb.y = yuv.x - 0.4681 * (yuv.z - 128.0) - 0.1873 * (yuv.y - 128.0);
	rgb.z = yuv.x + 1.8556 * (yuv.y - 128.0);
	return float4(rgb/255.0, 1.0);
}


//BT.601 PAL/ BT.601 NTSC /SMPTE 240M, color Range:Limited (CSC)
float4 funcNv12ToRGBABT601CSC(float3 yuv)
{
	float3 rgb;
	rgb.x = 1.1644 * (yuv.x - 16.0) + 1.5960 * (yuv.z - 128.0);
	rgb.y = 1.1644 * (yuv.x - 16.0) - 0.8129 * (yuv.z - 128.0)- 0.3917 * (yuv.y - 128.0);
	rgb.z = 1.1644 * (yuv.x - 16.0) + 2.0172 * (yuv.y - 128.0);
	return float4(rgb/255.0, 1.0);
}

//BT.601 PAL/ BT.601 NTSC /SMPTE 240M,, color Range:Full
float4 funcNv12ToRGBABT601HDTV(float3 yuv)
{
	float3 rgb;
	rgb.x = yuv.x + 1.4746 * (yuv.z - 128.0);
	rgb.y = yuv.x - 0.5713 * (yuv.z - 128.0) - 0.1645 * (yuv.y - 128.0);
	rgb.z = yuv.x + 1.8814 * (yuv.y - 128.0);
	return float4(rgb/255.0, 1.0);
}
float4 choosMode(float3 yuv, int _mode)
{
	yuv = yuv * 255.0;
	float4 outColor;
	switch(_mode)
	{
		case 0: //BT. 709, color Range:Limited.   (CSC) , default mode 
			outColor = funcNv12ToRGBABT709CSC(yuv);
			break;
		case 1: //BT. 709, color Range: Full. 
			outColor = funcNv12ToRGBABT709HDTV(yuv);
			break;
		case 2: //BT.601 PAL/ BT.601 NTSC /SMPTE 240M, color Range:Limited 
			outColor = funcNv12ToRGBABT601CSC(yuv);
			break;
		case 3://BT.601 PAL/ BT.601 NTSC /SMPTE 240M,, color Range:Full
			outColor = funcNv12ToRGBABT601HDTV(yuv);
			break;		
		default : 
			outColor = funcNv12ToRGBABT601CSC(yuv);
			break;
	}
	return outColor;
}
#define EQN_EPS 1e-9f

static bool isZero(float x) {
	return (x > -EQN_EPS && x < EQN_EPS);
}

PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    int width = overlay_Width;
    int height = overlay_Height;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
    float bw = float(dst_Width);
    float bh = float(dst_Height);
    float2 tc = In.TextureUV;
    int w = int(tc.x * ow / bw  * ow);
	int h = int(tc.y * oh / bh  * oh);
	
	
    float y, u, v;
    float r, g, b;
    int Y_tx, Y_ty, U_tx, U_ty;
    int offsetY = h * width + w;
    int offsetUV = h / 2 * ( width / 2) + w / 2;
    
    Y_tx = (offsetY) % width;
    Y_ty = (offsetY) / width;
    
    U_tx = (offsetUV) % (width / 2);
    U_ty = (offsetUV) / (width / 2);
    
    float4 InYColor = overlay0.Sample(TextureSampler, (float2)(Y_tx / ow, Y_ty / oh));
    float4 InUVColor = overlay1.Sample(TextureSampler, (float2)(U_tx / ow, U_ty / oh));
    y = InYColor.x;
    u = InUVColor.x;
    v = InUVColor.y;
    float4 retColor = choosMode(float3(y,u,v), mode);
   
    Output.RGBColor = retColor;

    return Output;

}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}

